// config: norepeat

#include "GetObjects.js"
#include "EditOrientations.js"

function GetPoint( pointpicker )
{
	while ( 1 )
	{
		if ( !pointpicker.waitForEvent() )
			return false;
			
		if ( pointpicker.event == 'done' )
			return 'done';
			
		if ( pointpicker.event == 'finished' )
			return 'finished';
	}
}

function DoBlend()
{
	var objectpicker = moi.ui.createObjectPicker();
	objectpicker.allowCurves();
	objectpicker.min = 2;
	
	if ( !GetObjects( objectpicker ) )
		return;

	var objects = objectpicker.objects;

	var doingedges = (objects.numEdges >= 2);

	// Enable G3 for curves only, it doesn't work properly for surfaces yet.
	if ( doingedges )
		moi.ui.commandUI.blendcontinuity.remove( 2 );

	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SelectionPrompt' );
	moi.ui.showUI( 'BlendPrompt' );
	moi.ui.showUI( 'BlendOptions' );
	
	if ( !doingedges )
		moi.ui.hideUI( 'EdgeBlendOptions' );
	
	moi.ui.endUIUpdate();

	var factory = moi.command.createFactory( 'blend' );

	factory.setInput( 0, objects );

	factory.disableUpdate( true );
	moi.ui.bindUIToInput( 'blendcontinuity', 'value', factory.getInput(2) );	
	moi.ui.bindUIToInput( 'bulge', 'value', factory.getInput(3) );
	factory.disableUpdate( false );
	factory.update();
	
	var curves = objects;
	if ( objects.numEdges >= 2 )
		curves = factory.getRails();

	var event = '';
	
	function EventHandler( picker )
	{
		// Make EditOrientations() return if 'addsyncpoints' has been clicked.
	
		event = picker.event;
		if ( event == 'addsyncpoints' || event == 'planarsections' )
			return true;
			
		return false;
	}
	
	var syncpts = false;
	
	while ( 1 )
	{
		event = '';
	
		var options = { eventhandler:EventHandler };
	
		if ( !EditOrientations( curves, factory, 1, options ) )
			return;
			
		if ( event == 'addsyncpoints' )
		{
			while ( 1 )
			{		
				moi.ui.beginUIUpdate();
				moi.ui.hideUI( 'BlendPrompt' );
				moi.ui.hideUI( 'BlendOptions' );
				moi.ui.hideUI( 'SyncPointSecondPrompt' );
				moi.ui.showUI( 'SyncPointFirstPrompt' );
				moi.ui.endUIUpdate();
			
				moi.ui.clearPickedPoints();
				var pointpicker = moi.ui.createPointPicker();
			
				var pointresult = GetPoint( pointpicker );
				if ( pointresult === false )
					return;
				else if ( pointresult == 'done' )
					break;
					
				var ptA = pointpicker.pt;

				moi.ui.beginUIUpdate();
				moi.ui.hideUI( 'SyncPointFirstPrompt' );
				moi.ui.showUI( 'SyncPointSecondPrompt' );
				moi.ui.endUIUpdate();
				
				pointresult = GetPoint( pointpicker );
				if ( pointresult === false )
					return;
				else if ( pointresult == 'done' )
					break;
					
				var ptB = pointpicker.pt;
				
				if ( syncpts === false )
					syncpts = moi.createList();
				
				syncpts.add( ptA );
				syncpts.add( ptB );
				
				factory.setInput( 4, syncpts );
				factory.update();
			}
				
			moi.ui.beginUIUpdate();
			moi.ui.hideUI( 'SyncPointFirstPrompt' );
			moi.ui.hideUI( 'SyncPointSecondPrompt' );
			moi.ui.showUI( 'BlendPrompt' );
			moi.ui.showUI( 'BlendOptions' );
			moi.ui.endUIUpdate();
		}
		else if ( event == 'planarsections' )
		{
			moi.ui.beginUIUpdate();
			moi.ui.hideUI( 'BlendPrompt' );
			moi.ui.hideUI( 'BlendOptions' );
			moi.ui.hideUI( 'done' );
			moi.ui.showUI( 'PlanarSectionsFirstPrompt' );
			moi.ui.endUIUpdate();
		
			moi.ui.clearPickedPoints();
			var pointpicker = moi.ui.createPointPicker();
			
			if ( !GetPoint( pointpicker ) )
				return;
				
			var PtA = pointpicker.pt;
				
			moi.ui.beginUIUpdate();
			moi.ui.hideUI( 'PlanarSectionsFirstPrompt' );
			moi.ui.showUI( 'PlanarSectionsSecondPrompt' );
			moi.ui.endUIUpdate();
			
			if ( !GetPoint( pointpicker ) )
				return;
				
			var PtB = pointpicker.pt;
				
			moi.ui.beginUIUpdate();
			moi.ui.hideUI( 'PlanarSectionsSecondPrompt' );
			moi.ui.showUI( 'BlendPrompt' );
			moi.ui.showUI( 'BlendOptions' );
			moi.ui.showUI( 'done' );
			moi.ui.endUIUpdate();
			
			moi.ui.clearPickedPoints();
			
			var dir = moi.vectorMath.makeVector( PtA, PtB );
			factory.setInput( 5, dir );
			factory.update();
		}
		else
		{
			// Done.
			break;
		}
	}
	
	factory.commit();
}

DoBlend();
